package ammo

import "a.yandex-team.ru/passport/infra/daemons/shooting_gallery/shooter/pkg/prospectortypes"

func (s *State) GetTask(host string) (prospectortypes.Task, error) {
	s.mutex.RLock()
	defer s.mutex.RUnlock()

	if s.task == nil || s.task.shouldStop {
		return prospectortypes.Task{}, nil
	}

	for _, h := range s.task.hosts {
		if h == host {
			return prospectortypes.Task{
				ID:       s.task.id,
				Duration: s.task.duration,
			}, nil
		}
	}

	return prospectortypes.Task{}, nil
}
