package shooting

import (
	"bytes"
	"os"
	"os/exec"
	"strings"
	"sync"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type CmdCreator interface {
	Create(command string) Cmd
}

type Cmd interface {
	Run() ([]byte, error)
	GetPid() int
	Signal(sig os.Signal) error
}

type CmdCreatorImpl struct {
}

type cmd struct {
	c *exec.Cmd
	m sync.RWMutex
	b bytes.Buffer
}

func (c *CmdCreatorImpl) Create(command string) Cmd {
	parts := strings.Fields(command)
	return &cmd{
		c: exec.Command(parts[0], parts[1:]...),
	}
}

func (c *cmd) start() error {
	c.c.Stdout = &c.b
	c.c.Stderr = &c.b

	c.m.Lock()
	defer c.m.Unlock()

	return c.c.Start()
}

func (c *cmd) Run() ([]byte, error) {
	if err := c.start(); err != nil {
		return c.b.Bytes(), err
	}

	err := c.c.Wait()

	return c.b.Bytes(), err
}

func (c *cmd) GetPid() int {
	c.m.RLock()
	defer c.m.RUnlock()

	return c.c.Process.Pid
}

func (c *cmd) Signal(sig os.Signal) error {
	c.m.Lock()
	defer c.m.Unlock()

	if c.c == nil || c.c.Process == nil {
		return xerrors.Errorf("process is nil")
	}

	return c.c.Process.Signal(sig)
}
