package srv

import (
	"context"
	"fmt"
	"net"
	"net/http"

	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/shooter/internal/shooter"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type httpCommonConfig struct {
	Port uint16 `json:"port"`
	Cert string `json:"cert"`
	Key  string `json:"key"`
}

type httpState struct {
	server *http.Server
	addr   string
}

func startCommonHTTP(cfg httpCommonConfig, stopper chan<- bool, sh *shooter.Shooter) (*httpState, error) {
	state := &httpState{
		addr: fmt.Sprintf(":%d", cfg.Port),
	}
	listener, err := net.Listen("tcp", state.addr)
	if err != nil {
		return nil, err
	}

	mux, err := sh.CreateMux()
	if err != nil {
		return nil, err
	}

	state.server = &http.Server{Handler: mux}

	go func() {
		logger.Log().Infof("Http server (common) started: '%s'", state.addr)
		err := state.server.ServeTLS(listener, cfg.Cert, cfg.Key)
		if err != nil && err != http.ErrServerClosed {
			logger.Log().Errorf("Http server (common) stopped: %s", err)
			stopper <- true
		}
	}()

	return state, nil
}

func (s *httpState) stop() {
	logger.Log().Infof("Http server stopping: '%s'", s.addr)
	if err := s.server.Shutdown(context.Background()); err != nil {
		logger.Log().Warnf("Shutting down interface: %s", err)
	}
}
