package srv

import (
	"fmt"
	"net"
	"net/http"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type httpUnistatConfig struct {
	Port uint16 `json:"port"`
}

func startUnistatHTTP(cfg httpUnistatConfig, stopper chan<- bool) (*httpState, error) {
	state := &httpState{
		addr: fmt.Sprintf("localhost:%d", cfg.Port),
	}
	listener, err := net.Listen("tcp", state.addr)
	if err != nil {
		return nil, err
	}

	mux := http.NewServeMux()
	mux.Handle("/unistat", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusOK)
		w.Header().Set("Content-Type", "application/json")
		_, _ = w.Write([]byte("[]"))
	})) // TODO

	state.server = &http.Server{Handler: mux}

	go func() {
		logger.Log().Infof("Http server (unistat) started: '%s'", state.addr)
		err := state.server.Serve(listener)
		if err != nil && err != http.ErrServerClosed {
			logger.Log().Errorf("Http server (unistat) stopped: %s", err)
			stopper <- true
		}
	}()

	return state, nil
}
