package clitypes

import "fmt"

type ListResult map[string]PackInfo

type AmmoListStatus int8

const (
	AmmoReady AmmoListStatus = iota
	AmmoInProgress
	AmmoInvalid
)

type HostPackInfo struct {
	Status    string         `json:"status"`
	StatusInt AmmoListStatus `json:"-"`
	Born      uint64         `json:"born"`
	Size      uint64         `json:"size"`
	Error     string         `json:"error,omitempty"`
}

type PackInfo struct {
	Hosts     map[string]HostPackInfo `json:"hosts"`
	Status    string                  `json:"status"`
	StatusInt AmmoListStatus          `json:"-"`
	Born      uint64                  `json:"born"`
	Size      uint64                  `json:"size"`
}

func (s AmmoListStatus) String() string {
	switch s {
	case AmmoReady:
		return "Ready"
	case AmmoInProgress:
		return "InProgress"
	case AmmoInvalid:
		return "Invalid"
	default:
		return fmt.Sprintf("Unknown AmmoListStatus: %d", s)
	}
}

type AmmoCreateResult struct {
	ID string `json:"id"`
}
