package misc

import (
	"os/exec"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type CmdRunner interface {
	Run(cmd string) ([]byte, error)
}

type CmdRunnerImpl struct {
}

func (c *CmdRunnerImpl) Run(cmd string) ([]byte, error) {
	logger.Log().Debugf("Trying to run cmd: '%s'", cmd)

	out, err := exec.Command("bash", "-c", cmd).CombinedOutput()
	if err != nil {
		err = xerrors.Errorf("failed to run cmd '%s': %w: %s", cmd, err, string(out))
		logger.Log().Errorf("Failed to run cmd: '%s'", cmd)
	} else {
		logger.Log().Infof("Succeed to run cmd: '%s'", cmd)
	}
	return out, err
}
