package misc

import (
	"bytes"
	"encoding/base64"

	"github.com/pierrec/lz4"

	"a.yandex-team.ru/library/go/core/xerrors"
)

func Compress(raw []byte) ([]byte, error) {
	buf := bytes.NewBuffer(nil)
	zw := lz4.NewWriter(buf)
	n, err := zw.Write(raw)
	if err != nil {
		return nil, xerrors.Errorf("failed to write to lz4: %w", err)
	}
	if n != len(raw) {
		return nil, xerrors.Errorf("invalid length written to lz4: %d. expected: %d", n, len(raw))
	}
	if err := zw.Close(); err != nil {
		return nil, xerrors.Errorf("failed to close writer to lz4: %w", err)
	}

	return buf.Bytes(), nil
}

func EncodeBody(raw []byte) []byte {
	base64Text := make([]byte, base64.RawURLEncoding.EncodedLen(len(raw)))
	base64.RawURLEncoding.Encode(base64Text, raw)
	return base64Text
}
