package misc

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
)

type HTTPClient interface {
	Get(path string, headers map[string]string) (int, []byte, error)
	Post(path string, body []byte, headers map[string]string) (int, []byte, error)
}

type HTTPClientImpl struct {
	Client *resty.Client
}

func (tg *HTTPClientImpl) Get(path string, headers map[string]string) (int, []byte, error) {
	req := tg.Client.R()
	req.SetContext(context.Background())
	req.SetHeaders(headers)

	resp, err := req.Get(path)

	if err != nil {
		return 0, nil, xerrors.Errorf("failed to get: %s: %w", path, err)
	}

	return resp.StatusCode(), resp.Body(), nil
}

func (tg *HTTPClientImpl) Post(path string, body []byte, headers map[string]string) (int, []byte, error) {
	req := tg.Client.R()
	req.SetContext(context.Background())
	req.SetHeaders(headers)
	req.SetBody(body)

	resp, err := req.Post(path)

	if err != nil {
		return 0, nil, xerrors.Errorf("failed to post: %s: %w", path, err)
	}

	return resp.StatusCode(), resp.Body(), nil
}
