package stateviewer

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/stateviewer/internal/perf"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/stateviewer/internal/top"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/stateviewer/internal/tvmclient"
	"a.yandex-team.ru/passport/infra/daemons/shooting_gallery/stateviewer/internal/versions"
)

type Config struct {
	Tvm        tvmclient.Config `json:"tvm"`
	Top        top.Config       `json:"top"`
	Perf       perf.Config      `json:"perf"`
	ShooterURL string           `json:"shooter_url"`
	Versions   versions.Config  `json:"versions"`
}

type Stateviewer struct {
	tvm       *tvmclient.TvmImpl
	top       *top.State
	perf      *perf.State
	versioner *versions.State
}

func NewStateviewer(cfg Config) (*Stateviewer, error) {
	tvm, err := tvmclient.NewTvm(cfg.Tvm)
	if err != nil {
		return nil, xerrors.Errorf("Failed to start tvm client: %w", err)
	}

	topper, err := top.NewTopper(cfg.Top, tvm, cfg.ShooterURL) // checks shooter accessability
	if err != nil {
		return nil, xerrors.Errorf("Failed to start topper: %w", err)
	}

	perfer, err := perf.NewPerfer(cfg.Perf, tvm, cfg.ShooterURL)
	if err != nil {
		return nil, xerrors.Errorf("Failed to start perfer: %w", err)
	}

	versioner, err := versions.NewVersioner(cfg.Versions, tvm, cfg.ShooterURL)
	if err != nil {
		return nil, xerrors.Errorf("Failed to start versioner: %w", err)
	}

	res := &Stateviewer{
		tvm:       tvm,
		top:       topper,
		perf:      perfer,
		versioner: versioner,
	}
	return res, nil
}

func (s *Stateviewer) Stop() {
	s.versioner.Stop()
	s.perf.Stop()
	s.top.Stop()
	s.tvm.Stop()
}
