import json
import sys


SETTINGS = {
    "development": {
        "HOST": 'tirole-api-test.yandex.net',
        "SECONDARY_HOST": '',
        "IP": '::',
    },
    "testing": {
        "HOST": 'tirole-api-test.yandex.net',
        "SECONDARY_HOST": 'tirole-api-test.passport.yandex.net',
        "IP": '2a02:6b8:0:3400:0:83f5:0:1',
    },
    "production": {
        "HOST": 'tirole-api.yandex.net',
        "SECONDARY_HOST": 'tirole-api.passport.yandex.net',
        "IP": '2a02:6b8:0:3400:0:83f5:0:3',
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
