import json
import sys


SETTINGS = {
    "development": {
        "SELF_TVM_ID": 2026118,
        "YT_CLUSTER": "markov",
        "YT_PATH": "//home/passport-tirole/development",
    },
    "testing": {
        "SELF_TVM_ID": 2026536,
        "YT_CLUSTER": "markov",
        "YT_PATH": "//home/passport-tirole/testing",
    },
    "production": {
        "SELF_TVM_ID": 2028120,
        "YT_CLUSTER": "markov",
        "YT_PATH": "//home/passport-tirole/production",
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
