package errs

import "fmt"

type InvalidParamError struct {
	Message string
}

func (e *InvalidParamError) Error() string {
	return e.Message
}

type NoRolesError struct {
	Message string
}

func (e *NoRolesError) Error() string {
	return e.Message
}

func IsNoRolesError(err error) bool {
	_, ok := err.(*NoRolesError)
	return ok
}

type TemporaryError struct {
	Message string
}

func (e *TemporaryError) Error() string {
	return e.Message
}

type BadSignError struct {
	Message string
}

func (e *BadSignError) Error() string {
	return e.Message
}

type UnauthorizedError struct {
	Message      string
	Description  string
	TicketStatus string
	LoggablePart string
}

func (e *UnauthorizedError) Error() string {
	if e.TicketStatus != "" || e.Description != "" {
		return fmt.Sprintf("%s. status=%s. desc=%s", e.Message, e.TicketStatus, e.Description)
	} else {
		return e.Message
	}
}

type AccessDenied struct {
	Message string
}

func (e *AccessDenied) Error() string {
	return e.Message
}
