package model

import "context"

type BackendProvider interface {
	PingProvider
	RolesProvider
	MappingProvider
}

type PingProvider interface {
	Ping(ctx context.Context) error
}

type RolesProvider interface {
	GetActualRevision(ctx context.Context, slug string) (res string, err error)
	GetActualRoles(ctx context.Context, slug string) (res ActualRoles, err error)
}

type MappingProvider interface {
	GetMapping(ctx context.Context, slug string) (Mapping, error)
}
