package unittest

import (
	"fmt"
	"io/ioutil"

	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/model"
)

const (
	mappingFileName = "mapping.yaml"
)

type mappingYaml struct {
	Slugs map[string]mappingYamlPerSlug `yaml:"slugs"`
}

type mappingYamlPerSlug struct {
	TvmIDs []tvm.ClientID `yaml:"tvmid"`
}

func readMapping(dir string) (map[string]model.Mapping, error) {
	filename := fmt.Sprintf("%s%s", dir, mappingFileName)

	body, err := ioutil.ReadFile(filename)
	if err != nil {
		return nil, xerrors.Errorf("failed to read file body '%s': %v", filename, err)
	}

	rawMappings := mappingYaml{}
	err = yaml.Unmarshal(body, &rawMappings)
	if err != nil {
		return nil, xerrors.Errorf("failed to parse file '%s': %v", filename, err)
	}

	result := make(map[string]model.Mapping)
	for slug, tvmids := range rawMappings.Slugs {
		t := make(model.Mapping)
		for _, id := range tvmids.TvmIDs {
			t[id] = nil
		}

		result[slug] = t
	}

	return result, nil
}
