package ytc

import (
	"context"
	"fmt"
	"strconv"
	"time"

	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/model"
)

type ActualRevision struct {
	Meta model.Meta `yson:"meta"`
}

func (c *Client) GetActualRevision(ctx context.Context, slug string) (res string, err error) {
	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil && !errs.IsNoRolesError(err) {
			c.unistat.errs.Inc()
		}
	}()

	query := fmt.Sprintf(
		`
meta
FROM [%s/roles]
WHERE slug = %s
ORDER BY slug,reversed_revision
LIMIT 1`,
		c.path,
		strconv.Quote(slug),
	)

	var response ActualRevision
	err = c.readSingleRow(ctx, query, &response)
	if err != nil {
		if errs.IsNoRolesError(err) {
			return "", &errs.NoRolesError{
				Message: fmt.Sprintf("There are no roles for slug=%s", slug),
			}
		} else {
			return "", &errs.TemporaryError{Message: err.Error()}
		}
	}
	res = response.Meta.RevisionExt

	return res, nil
}
