package ytc

import (
	"context"
	"fmt"
	"strconv"
	"time"

	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/model"
)

func (c *Client) GetActualRoles(ctx context.Context, slug string) (res model.ActualRoles, err error) {
	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil && !errs.IsNoRolesError(err) {
			c.unistat.errs.Inc()
		}
	}()

	query := fmt.Sprintf(
		`
meta,blob
FROM [%s/roles]
WHERE slug = %s
ORDER BY slug,reversed_revision
LIMIT 1`,
		c.path,
		strconv.Quote(slug),
	)

	err = c.readSingleRow(ctx, query, &res)
	if err != nil {
		if errs.IsNoRolesError(err) {
			return res, &errs.NoRolesError{
				Message: fmt.Sprintf("There are no roles for slug=%s", slug),
			}
		} else {
			return res, &errs.TemporaryError{Message: err.Error()}
		}
	}

	return res, err
}
