package ytc

import (
	"context"
	"fmt"
	"strconv"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/model"
	"a.yandex-team.ru/passport/infra/libs/go/ytsimple"
	"a.yandex-team.ru/yt/go/yt"
)

func (c *Client) GetMapping(ctx context.Context, slug string) (model.Mapping, error) {
	var err error
	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil {
			c.unistat.errs.Inc()
		}
	}()

	query := fmt.Sprintf(
		`
tvm_id
FROM [%s/mapping]
WHERE slug = %s`,
		c.path,
		strconv.Quote(slug),
	)

	type Row struct {
		TvmID uint32 `yson:"tvm_id"`
	}

	res := make(model.Mapping)

	c.unistat.requests.Inc()
	err = ytsimple.SelectAll(ctx, c.yc, query, c.timeout, func(reader yt.TableReader) error {
		row := Row{}
		if err := ytsimple.ScanRow(reader, &row); err != nil {
			return err
		}

		res[tvm.ClientID(row.TvmID)] = nil
		return nil
	})
	if err != nil {
		return nil, &errs.TemporaryError{Message: err.Error()}
	}

	return res, nil
}
