package tirole

import (
	"fmt"
	"strconv"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tirole/internal/errs"
)

func getOptionalUIntParam(c echo.Context, key string) (*uint64, error) {
	value := c.Request().URL.Query().Get(key)
	if value == "" {
		return nil, nil
	}

	valueInt, err := strconv.ParseUint(value, 10, 64)
	if err != nil || valueInt == 0 {
		return nil, &errs.InvalidParamError{
			Message: fmt.Sprintf("invalid param: '%s' must be positive int, got '%s'", key, value),
		}
	}

	return &valueInt, nil
}

func getRequiredStringParam(c echo.Context, key string) (string, error) {
	value := c.Request().URL.Query().Get(key)
	if value == "" {
		return "", &errs.InvalidParamError{
			Message: fmt.Sprintf("invalid param: missing '%s'", key),
		}
	}

	return value, nil
}

func getRevisionFromHeader(key, value string) (string, error) {
	if value == "" {
		return "", nil
	}

	res, err := strconv.Unquote(value)
	if err != nil || res == "" {
		return "", &errs.InvalidParamError{
			Message: fmt.Sprintf("invalid header: '%s' contains incorrect revision '%s'", key, value),
		}
	}

	return res, nil
}
