#! /bin/sh

set -e


run(){
    TABLE="$1"
    SCHEMA="$2"

#    yt --proxy markov remove -f $TABLE
#    yt --proxy seneca-vla remove -f $TABLE
#    yt --proxy seneca-man remove -f $TABLE
#    yt --proxy seneca-sas remove -f $TABLE

    ./create_table.py new-replicated --cluster markov --schema_type $SCHEMA --name $TABLE
    ./create_table.py new-replica --cluster markov --schema_type $SCHEMA --name $TABLE \
        --replica-cluster seneca-vla --replica-name $TABLE --sync
    ./create_table.py new-replica --cluster markov --schema_type $SCHEMA --name $TABLE \
        --replica-cluster seneca-man
    ./create_table.py new-replica --cluster markov --schema_type $SCHEMA --name $TABLE \
        --replica-cluster seneca-sas
}


run "//home/passport-tirole/development/roles"   "roles"
run "//home/passport-tirole/development/mapping" "mapping"
run "//home/passport-tirole/testing/roles"       "roles"
run "//home/passport-tirole/testing/mapping"     "mapping"
run "//home/passport-tirole/production/roles"    "roles"
run "//home/passport-tirole/production/mapping"  "mapping"
