import json
import sys


def dump_array(arr):
    return json.dumps(arr)


SETTINGS = {
    "development": {
        "SELF_TVM_ID": 2028122,
        "ALLOWED_TVMID": dump_array([11]),
        "YT_PATH": "//home/passport-tirole/development",
    },
    "testing": {
        "SELF_TVM_ID": 2028122,
        "ALLOWED_TVMID": dump_array([2001602]),
        "YT_PATH": "//home/passport-tirole/testing",
    },
    "production": {
        "SELF_TVM_ID": 2028124,
        "ALLOWED_TVMID": dump_array([2001600]),
        "YT_PATH": "//home/passport-tirole/production",
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
