package errs

import "fmt"

type InvalidRequestError struct {
	Message string
}

func (e *InvalidRequestError) Error() string {
	return e.Message
}

type TemporaryError struct {
	Message string
}

func (e *TemporaryError) Error() string {
	return e.Message
}

type UnauthorizedError struct {
	Message      string
	Description  string
	TicketStatus string
	LoggablePart string
}

func (e *UnauthorizedError) Error() string {
	if e.TicketStatus != "" || e.Description != "" {
		return fmt.Sprintf("%s. status=%s. desc=%s", e.Message, e.TicketStatus, e.Description)
	} else {
		return e.Message
	}
}
