package reqs

import (
	_ "embed"
	"fmt"
	"os"

	"github.com/santhosh-tekuri/jsonschema/v5"
)

type UploadRoles struct {
	SystemSlug string `json:"system_slug"`
	Roles      Roles  `json:"roles"`
}

type Roles struct {
	Revision uint64     `json:"revision"`
	BornDate uint64     `json:"born_date"`
	Tvm      *Consumers `json:"tvm,omitempty"`
	User     *Consumers `json:"user,omitempty"`
}

type RolesExt struct {
	RevisionExt string     `json:"revision"`
	BornDate    uint64     `json:"born_date"`
	Tvm         *Consumers `json:"tvm,omitempty"`
	User        *Consumers `json:"user,omitempty"`
}

// ConsumerID is TvmID or UID
type ConsumerID string
type Consumers map[ConsumerID]ConsumerRoles

type RoleName string
type ConsumerRoles map[RoleName][]Entry

type Entry map[string]string

var UploadRolesSchema *jsonschema.Schema

//go:embed upload_roles.schema.json
var uploadRolesSchema []byte

func init() {
	s, err := jsonschema.CompileString("schema.json", string(uploadRolesSchema))
	if err != nil {
		_, _ = fmt.Fprintf(os.Stderr, "Failed to compile json schema: %s", err.Error())
		os.Exit(1)
	}
	UploadRolesSchema = s
}
