package tiroleinternal

import (
	"fmt"
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/log/ctxlog"
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/internal/errs"
	"a.yandex-team.ru/passport/shared/golibs/httpdaemon/middlewares"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type SimpleResponse struct {
	Status string `json:"status"`
}

type ErrorResponse struct {
	Error string `json:"error"`
}

func (t *TiroleInternal) sendErrorResponse(c echo.Context, err error) error {
	if err == nil {
		err = xerrors.New("some error occured but original message was lost")
	}

	switch err := err.(type) {

	case *errs.InvalidRequestError:
		t.unistat.errInvalidRequest.Inc()
		ctxlog.Debugf(c.Request().Context(), logger.Log(), "%s", err)
		return sendErrorResponseImpl(c, http.StatusBadRequest, err.Error())

	case *errs.TemporaryError:
		t.unistat.errTmp.Inc()
		ctxlog.Debugf(c.Request().Context(), logger.Log(), "%s", err)
		return sendErrorResponseImpl(c, http.StatusInternalServerError, err.Error())

	case *errs.UnauthorizedError:
		t.unistat.errUnauthorized.Inc()
		ctxlog.Debugf(c.Request().Context(), logger.Log(), "%s. '%s'", err, err.LoggablePart)
		return sendErrorResponseImpl(c, http.StatusUnauthorized, err.Error())
	}

	t.unistat.errUnknown.Inc()
	ctxlog.Errorf(c.Request().Context(), logger.Log(), "Unexpected error: %s", err)
	return sendErrorResponseImpl(c, http.StatusInternalServerError, err.Error())
}

func sendErrorResponseImpl(c echo.Context, code int, err string) error {
	// TODO: extend
	txt := fmt.Sprintf(
		"%s. request_id=%s",
		err,
		middlewares.ContextReqID(c.Request().Context()),
	)

	return c.JSON(code, ErrorResponse{Error: txt})
}
