package ytc

import (
	"context"
	"fmt"
	"sync"
	"time"

	"a.yandex-team.ru/passport/infra/libs/go/ytsimple"
	"a.yandex-team.ru/yt/go/yt"
)

func (c *Client) Ping(ctx context.Context) error {
	queries := []string{
		fmt.Sprintf(`slug FROM [%s/mapping] LIMIT 1`, c.path),
		fmt.Sprintf(`slug FROM [%s/roles] LIMIT 1`, c.path),
	}
	errs := make([]error, len(queries))

	var wg sync.WaitGroup
	for idx := range queries {
		wg.Add(1)

		go func(idx int) {
			errs[idx] = c.pingImpl(ctx, queries[idx])
			wg.Done()
		}(idx)
	}
	wg.Wait()

	for _, err := range errs {
		if err != nil {
			return err
		}
	}

	return nil
}

func (c *Client) pingImpl(ctx context.Context, query string) error {
	var err error

	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil {
			c.unistat.errs.Inc()
		}
	}()
	c.unistat.requests.Inc()

	err = ytsimple.SelectAll(ctx, c.yc, query, c.timeout, func(reader yt.TableReader) error {
		var dummy map[string]interface{}
		return ytsimple.ScanRow(reader, &dummy)
	})
	return err
}
