package ytc

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/yt/go/ypath"
	"a.yandex-team.ru/yt/go/yt"
)

type UploadRolesMetaReq struct {
	Unixtime      uint64 `yson:"unixtime"`
	Codec         string `yson:"codec"`
	DecodedSize   uint64 `yson:"decoded_size"`
	DecodedSha256 string `yson:"decoded_sha256"`
	EncodedHmac   string `yson:"encoded_hmac"`
	RevisionExt   string `yson:"revision_external"`
	Revision      uint64 `yson:"revision_original"`
	Borndate      string `yson:"born_date"`
}

type UploadRolesReq struct {
	Slug     string             `yson:"slug"`
	Revision uint64             `yson:"reversed_revision"`
	Meta     UploadRolesMetaReq `yson:"meta"`
	Blob     []byte             `yson:"blob"`
}

func (c *Client) UploadRoles(ctx context.Context, req *UploadRolesReq) error {
	var err error

	start := time.Now()
	defer func() {
		c.unistat.responseTimings.Insert(time.Since(start))
		if err != nil {
			c.unistat.errs.Inc()
		}
	}()
	c.unistat.requests.Inc()

	path := ypath.Path(fmt.Sprintf("%s/roles", c.path))

	requireSyncReplica := true
	atomicity := yt.AtomicityFull
	options := &yt.InsertRowsOptions{
		RequireSyncReplica: &requireSyncReplica,
		Atomicity:          &atomicity,
	}

	if err = c.yc.InsertRows(ctx, path, []interface{}{req}, options); err != nil {
		return xerrors.Errorf(
			"UploadRoles: failed to insert row: %w",
			err,
		)
	}

	return nil
}
