package config

import (
	"encoding/json"
	"io/ioutil"

	"github.com/spf13/pflag"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/internal/tiroleinternal"
)

type Factory struct {
	ConfigPath string
}

func (f *Factory) AddFlag(flags *pflag.FlagSet) {
	flags.StringVar(
		&f.ConfigPath,
		"config",
		"/etc/yandex/passport-tirole-internal/tirole_internal.conf",
		"")
}

func (f *Factory) Get() (*tiroleinternal.Config, error) {
	configBody, err := ioutil.ReadFile(f.ConfigPath)
	if err != nil {
		return nil, xerrors.Errorf("Failed to read config: %w: %s", err, f.ConfigPath)
	}

	type Dummy struct {
		Service tiroleinternal.Config `json:"service"`
	}

	res := Dummy{}
	if err := json.Unmarshal(configBody, &res); err != nil {
		return nil, xerrors.Errorf("Failed to parse config: %w: %s", err, f.ConfigPath)
	}

	return &res.Service, nil
}
