package modes

import (
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/tools/dbscripts/internal/modes/updaterows"
)

func Execute() error {
	rootCmd := cobra.Command{
		Use: "dbscripts",
		PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
			return nil
		},
		Short: "This tool allows to run some scripts for tirole",
	}
	rootCmd.AddCommand(updaterows.Cmd())

	rootCmd.AddCommand(&cobra.Command{
		Use:   "bash_completion",
		Short: "Generates bash completion scripts",
		Long: `Add to your ~/.bashrc line and restart your bash:
source <(dbscripts bash_completion)
`,
		Run: func(cmd *cobra.Command, args []string) {
			_ = rootCmd.GenBashCompletion(os.Stdout)
		},
	})

	rootCmd.SilenceUsage = true
	return rootCmd.Execute()
}
