package updaterows

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/tools/dbscripts/internal/config"
)

func Cmd() *cobra.Command {
	cfgFactory := config.Factory{}

	var fromSlug string
	var fromReversedRevision uint64
	var limit uint16

	res := &cobra.Command{
		Use:     "update-rows",
		Short:   "",
		Example: "dbscripts update-rows",
		RunE: func(cmd *cobra.Command, args []string) error {
			cfg, err := cfgFactory.Get()
			if err != nil {
				return err
			}

			return run(cfg, fromSlug, fromReversedRevision, limit)
		},
	}

	flags := res.Flags()
	cfgFactory.AddFlag(flags)

	flags.StringVar(&fromSlug, "from_slug", "", "start from 'slug'")
	flags.Uint64Var(&fromReversedRevision, "from_reversed_revision", 0, "start from 'reversed_revision'")
	flags.Uint16Var(&limit, "limit", 10, "")

	return res
}
