package updaterows

import (
	"context"
	"fmt"
	"os"
	"strconv"
	"time"

	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/internal/tiroleinternal"
	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/internal/ytc"
	"a.yandex-team.ru/passport/infra/daemons/tirole_internal/keys"
	"a.yandex-team.ru/passport/infra/libs/go/ytsimple"
	"a.yandex-team.ru/yt/go/yson"
	"a.yandex-team.ru/yt/go/yt"
)

func run(cfg *tiroleinternal.Config, fromSlug string, fromReversedRevision uint64, limit uint16) error {
	cl, err := ytc.CreateLowLevelClient(&cfg.Yt)
	if err != nil {
		return err
	}

	keyMap, err := keys.InitKeyMap(cfg.KeyMap)
	if err != nil {
		return err
	}

	count := limit
	for count == limit || err != nil {
		fromSlug, fromReversedRevision, count, err = runBatch(cl, keyMap, cfg.Yt.Path, fromSlug, fromReversedRevision, limit)
		if err != nil {
			_, _ = fmt.Fprintf(os.Stderr, "====== Batch failed: %s\n", err)
			continue
		}

		_, _ = fmt.Fprintf(os.Stderr, "====== Batch finished\n")
	}

	return err
}

func runBatch(
	client yt.Client,
	keyMap *keys.KeyMap,
	dir string,
	fromSlug string,
	fromReversedRevision uint64,
	limit uint16,
) (string, uint64, uint16, error) {
	fromSlug = strconv.Quote(fromSlug)
	query := fmt.Sprintf(
		`
slug,reversed_revision,meta,blob
FROM [%s/roles]
WHERE (slug=%s AND reversed_revision>%d) OR slug>%s
LIMIT %d`,
		dir,
		fromSlug,
		fromReversedRevision,
		fromSlug,
		limit,
	)

	lastSlug := ""
	lastReversedRevision := uint64(0)
	count := uint16(0)

	timeout := yson.Duration(time.Duration(10000) * time.Millisecond)
	err := ytsimple.SelectAll(context.Background(), client, query, timeout, func(reader yt.TableReader) error {
		row := ytc.UploadRolesReq{}
		if err := ytsimple.ScanRow(reader, &row); err != nil {
			return err
		}

		lastSlug = row.Slug
		lastReversedRevision = row.Revision
		count += 1

		return tryUpdate(client, keyMap, &row, dir)
	})
	if err != nil {
		return fromSlug, fromReversedRevision, 0, err
	}

	return lastSlug, lastReversedRevision, count, nil
}
