import argparse
import brotli
import yt.wrapper


def do(slug, token=None, cluster=None):
    yt_client = yt.wrapper.YtClient(proxy=cluster, token=token)

    result = yt.wrapper.dynamic_table_commands.select_rows(
        query='blob FROM [//home/passport-tirole/production/roles] WHERE slug="%s" LIMIT 1' % slug,
        client=yt_client,
    )
    for r in result:
        print(brotli.decompress(yt.yson.get_bytes(r['blob'])).decode('utf-8'))


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='dummy project')
    parser.add_argument('--slug', type=str, required=True)
    parser.add_argument('--cluster', default='seneca-sas', help='')
    args = parser.parse_args()

    do(
        slug=args.slug,
        cluster=args.cluster,
    )
