import sys


SAS = "sas"
IVA = "iva"
MAN = "man"
MYT = "myt"
VLA = "vla"


SETTINGS = {
    "development": {
        "HTTP_PORT": 10088,
        "UNISTAT_PORT": 10188,
        "MONITOR_PORT": 3340,
        "KEYS_ACCEPTABLE_AGE": 345600,
        "CHECKSECRET_CLIENT_ID": 39,
        "DST_COUNT_LIMIT": 10,
        "DB_HOST": "cnt-dbs-test.passport.yandex.net",
        "DB_NAME": "tvmdbcentral_yateam",
        "TVMID_BB_PROD": 162,
        "TVMID_BB_PROD_YATEAM": 164,
        "TVMID_BB_TEST": 224,
        "TVMID_BB_TEST_YATEAM": 168,
        "TVMID_BB_STRESS": 170,
        "TVMID_BB_MIMINO": 188,
        "TVMID_TVM": 172,
        "PREGENERATION_KEY_TTL": 60,
        "VERIFYSSH_CLIENT_ID": 27,
        "OAUTH_HOST": "oauth-internal.yandex-team.ru",
        "STAFF_HOST": "staff-api.yandex-team.ru",
        "ABC_ENABLED": "1",
    },
    "testing": {
        "HTTP_PORT": 10080,
        "UNISTAT_PORT": 10180,
        "MONITOR_PORT": 3334,
        "KEYS_ACCEPTABLE_AGE": 345600,
        "CHECKSECRET_CLIENT_ID": 2001924,
        "DST_COUNT_LIMIT": 500,
        "DB_HOST": "cnt-dbs-test.passport.yandex.net",
        "DB_NAME": "tvmdbcentral_yateam",
        "TVMID_BB_PROD": 162,
        "TVMID_BB_PROD_YATEAM": 164,
        "TVMID_BB_TEST": 224,
        "TVMID_BB_TEST_YATEAM": 168,
        "TVMID_BB_STRESS": 170,
        "TVMID_BB_MIMINO": 188,
        "TVMID_TVM": 172,
        "PREGENERATION_KEY_TTL": 86400,
        "VERIFYSSH_CLIENT_ID": "7,2000238",
        "OAUTH_HOST": "oauth-test.yandex-team.ru",
        "STAFF_HOST": "staff-api-prestable.qloud.yandex-team.ru",
        "ABC_ENABLED": "0",
    },
    "production": {
        "HTTP_PORT": 10080,
        "UNISTAT_PORT": 10180,
        "MONITOR_PORT": 3334,
        "KEYS_ACCEPTABLE_AGE": {
            IVA: 345600,
            MAN: 345600,
            MYT: 345600,
            SAS: 259200,
            VLA: 345600,
        },
        "CHECKSECRET_CLIENT_ID": 2001924,
        "DST_COUNT_LIMIT": 500,
        "DB_HOST": "yateam-dbs.passport.yandex.net",
        "DB_NAME": "tvmdbcentral",
        "TVMID_BB_PROD": 222,
        "TVMID_BB_PROD_YATEAM": 223,
        "TVMID_BB_TEST": 224,
        "TVMID_BB_TEST_YATEAM": 225,
        "TVMID_BB_STRESS": 226,
        "TVMID_BB_MIMINO": 239,
        "TVMID_TVM": 227,
        "PREGENERATION_KEY_TTL": 86400,
        "VERIFYSSH_CLIENT_ID": "10,2000237",
        "OAUTH_HOST": "oauth-internal.yandex-team.ru",
        "STAFF_HOST": "staff-api.yandex-team.ru",
        "ABC_ENABLED": "1",
    },
}


def do(template, env, dc):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        if isinstance(value, dict):
            value = value[dc]
        template = template.replace('{{%s}}' % key, str(value))

    if '{{' in template or '}}' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


def get_dc(hostname):
    if hostname.startswith('tvm-f'):
        return MAN
    if hostname.startswith('tvm-i'):
        return IVA
    if hostname.startswith('tvm-s'):
        return SAS
    if hostname.startswith('tvm-m'):
        return MYT
    if hostname.startswith('tvm-v'):
        return VLA

    if 'dev' in hostname or 'test' in hostname:
        return None

    raise Exception('Unconfigured DC for host: %s' % hostname)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: %s <template_file> <env_type> <hostname>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    env = sys.argv[2]
    hostname = sys.argv[3]

    do(template, env, get_dc(hostname))
