#include "exception.h"

namespace NPassport::NTvm {
    static const TString MSG_MUST_BE_A_NUMBER = "Arg must be a number: ";
    static const TString MSG_MUST_BE_A_LIST_OF_NUMBERS = "Arg must be a comma-separated array of numbers: ";
    TIncorrectArgException TIncorrectArgException::MustBeNumber(const TString& arg) {
        return TIncorrectArgException(arg) << MSG_MUST_BE_A_NUMBER << arg;
    }
    TIncorrectArgException TIncorrectArgException::MustBeAListOfNumbers(const TString& arg) {
        return TIncorrectArgException(arg) << MSG_MUST_BE_A_LIST_OF_NUMBERS << arg;
    }
}
