#pragma once

#include <util/generic/string.h>
#include <util/generic/yexception.h>
#include <util/stream/str.h>

namespace NPassport::NTvm {
    class TException: public std::exception {
    public:
        explicit TException(const TString& what = TString())
            : What_(what)
        {
        }

        TException(const TException& copy)
            : What_(copy.what())
        {
        }
        ~TException() noexcept override = default;

        const char* what() const noexcept override {
            return What_.c_str();
        }

        template <typename E, typename T>
        friend typename std::enable_if<std::is_base_of<TException, typename std::remove_reference<E>::type>::value, E&&>::type
        operator<<(E&& e, const T& t)
        {
            TStringOutput stream(e.What_);
            stream << t;
            return std::forward<E>(e);
        }

    private:
        TString What_;
    };

    class TMissingArgException: public TException {
    };

    class TIncorrectArgException: public TException {
    public:
        explicit TIncorrectArgException(const TString& arg)
            : Arg_(arg)
        {
        }

        const TString& WhatArg() const {
            return Arg_;
        }

        static TIncorrectArgException MustBeNumber(const TString& arg);
        static TIncorrectArgException MustBeAListOfNumbers(const TString& arg);

    private:
        TString Arg_;
    };
}
