#include "result.h"

namespace NPassport::NTvm {
    static const TString TEXT_PLAIN = "text/plain";
    static const TString BLOB = "application/octet-stream";

    // Do not touch it: some consumers rely on this behavior (PASSPINCIDENTS-3)
    static const TString TEXT_JSON = "text/json";

    const TString& TResult::ContentType() const {
        if (ContentType_ == EContentType::TextPlain) {
            return TEXT_PLAIN;
        }
        if (ContentType_ == EContentType::TextJson) {
            return TEXT_JSON;
        }
        return BLOB;
    }
}
