#pragma once

#include "status.h"

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/generic/string.h>

namespace NPassport::NTvm {
    class TResult {
    public:
        enum class EContentType {
            TextPlain,
            TextJson,
            Blob
        };

        using THeaders = TStackVec<std::pair<TString, TString>, 4>;

        TResult() = default;

        template <class T>
        TResult(T&& ticket, EContentType type);
        template <class T>
        TResult(T&& errorMsg, const TStatus& status);

        TResult(const TResult&) = default;
        TResult& operator=(const TResult&) = default;
        TResult(TResult&&) = default;
        TResult& operator=(TResult&&) = default;

        const TString& Body() const {
            return Body_;
        }

        const TString& ContentType() const;

        const TStatus& Status() const {
            return Status_;
        }

        void AddHeader(const TString& name, const TString& value) {
            Headers_.push_back({name, value});
        }

        const THeaders& Headers() const {
            return Headers_;
        }

    private:
        TStatus Status_;

        EContentType ContentType_ = EContentType::TextJson;
        TString Body_;
        THeaders Headers_;
    };

    template <class T>
    inline TResult::TResult(T&& ticket, TResult::EContentType type)
        : Status_(TStatus::OK)
        , ContentType_(type)
        , Body_(std::forward<T>(ticket))
    {
    }

    template <class T>
    inline TResult::TResult(T&& errorMsg, const TStatus& status)
        : Status_(status)
        , Body_(std::forward<T>(errorMsg))
    {
    }
}
