#include "serializer.h"

#include "result.h"
#include "status.h"

#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/request/request.h>

namespace NPassport::NTvm {
    static const TString HEADER_CONTENT_TYPE = "Content-Type";

    void TSerializer::Serialize(NCommon::TRequest& req, const TResult& result) {
        req.SetStatus(result.Status().CodeEnum());
        req.SetHeader(HEADER_CONTENT_TYPE, result.ContentType());

        if (result.Status().IsOk()) {
            req.Write(result.Body());
        } else {
            req.Write(Error(result, req));
        }
    }

    static const TString REQUEST_ID_ = "request_id";
    static const TString STATUS_ = "status";
    static const TString ERROR_ = "error";
    static const TString DESC_ = "desc";
    TString TSerializer::Error(const TResult& result, const NCommon::TRequest& req) {
        TString json;
        NJson::TWriter jw(json);
        NJson::TObject root(jw);

        root.Add(REQUEST_ID_, req.GetRequestId());
        root.Add(STATUS_, result.Status().String());
        root.Add(ERROR_, result.Status().Error());
        root.Add(DESC_, result.Body());

        return json;
    }

}
