#include "status.h"

namespace NPassport::NTvm {
    const TString TStatus::STR_ERR_REQUEST = "ERR_REQUEST";
    const TString TStatus::STR_MISSING_ = "MISSING.";
    const TString TStatus::STR_INCORRECT_TS = "INCORRECT.ts";
    const TString TStatus::STR_INCORRECT_ = "INCORRECT.";

    const TStatus TStatus::OK("", "", true, HTTP_OK);
    const TStatus TStatus::REGULAR_NOT_FOUND("404", "", true, HTTP_NOT_FOUND);

    const TStatus TStatus::ERROR_REQUEST__INCORRECT_TS("ERR_REQUEST", "INCORRECT_TS", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_REQUEST__BROKEN_SIGN("ERR_REQUEST", "BROKEN_SIGN", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_REQUEST__MISSING("ERR_REQUEST", "MISSING", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_REQUEST__POST_ONLY("ERR_REQUEST", "POST_ONLY", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_REQUEST__GET_ONLY("ERR_REQUEST", "GET_ONLY", false, HTTP_BAD_REQUEST);

    const TStatus TStatus::ERROR_CLIENT__NOT_FOUND("ERR_CLIENT", "NOT_FOUND", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_CLIENT__GRANT_TYPE("ERR_CLIENT", "GRANT_TYPE", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_CLIENT__INCORRECT("ERR_CLIENT", "INCORRECT", false, HTTP_BAD_REQUEST);

    const TStatus TStatus::ERROR_CRED__UID_NOT_ALLOWED("ERR_CREDENTIALS", "UID_NOT_ALLOWED", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_CRED__BB_REJECT("ERR_CREDENTIALS", "BB_REJECT", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_CRED__NO_SSH_KEY("ERR_CREDENTIALS", "NO_SSH_KEY", false, HTTP_BAD_REQUEST);
    const TStatus TStatus::ERROR_CRED__SSH_BROKEN("ERR_CREDENTIALS", "SSH_BROKEN", false, HTTP_BAD_REQUEST);

    const TStatus TStatus::ERROR_FATAL("SERVICE_UNAVAILABLE", "UNEXPECTED_ERROR", false, HTTP_INTERNAL_SERVER_ERROR);

    const TStatus TStatus::SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE", "INIT_FAILED", false, HTTP_SERVICE_UNAVAILABLE);
}
