#pragma once

#include <library/cpp/http/misc/httpcodes.h>

#include <util/generic/string.h>
#include <util/system/types.h>

namespace NPassport::NTvm {
    class TStatus {
    public:
        TStatus() = default;

        TStatus(const TString& codeString, const TString& error, bool isOk = false, HttpCodes codeInt = HTTP_BAD_REQUEST)
            : Error_(error)
            , CodeString_(codeString)
            , CodeInt_(codeInt)
            , IsOk_(isOk)
        {
        }

        static const TString STR_ERR_REQUEST;
        static const TString STR_MISSING_;
        static const TString STR_INCORRECT_TS;
        static const TString STR_INCORRECT_;

        static const TStatus OK;
        static const TStatus REGULAR_NOT_FOUND;

        static const TStatus ERROR_REQUEST__INCORRECT_TS;
        static const TStatus ERROR_REQUEST__BROKEN_SIGN;
        static const TStatus ERROR_REQUEST__MISSING;
        static const TStatus ERROR_REQUEST__POST_ONLY;
        static const TStatus ERROR_REQUEST__GET_ONLY;

        static const TStatus ERROR_CLIENT__NOT_FOUND;
        static const TStatus ERROR_CLIENT__GRANT_TYPE;
        static const TStatus ERROR_CLIENT__INCORRECT;

        static const TStatus ERROR_CRED__UID_NOT_ALLOWED;
        static const TStatus ERROR_CRED__BB_REJECT;
        static const TStatus ERROR_CRED__NO_SSH_KEY;
        static const TStatus ERROR_CRED__SSH_BROKEN;

        static const TStatus ERROR_FATAL;

        static const TStatus SERVICE_UNAVAILABLE;

    public:
        bool IsOk() const {
            return IsOk_;
        }

        const TString& String() const {
            return CodeString_;
        }

        HttpCodes CodeEnum() const {
            return CodeInt_;
        }

        bool Is4Xx() const {
            return CodeInt_ == HTTP_BAD_REQUEST;
        }

        const TString& Error() const {
            return Error_;
        }

    private:
        TString Error_;
        TString CodeString_;
        HttpCodes CodeInt_ = HTTP_INTERNAL_SERVER_ERROR;
        bool IsOk_ = false;
    };

}
