#pragma once

#include "keys.h"
#include "storage.h"

namespace NPassport::NTvm::NPregen {
    class TDiskCache {
    public:
        TDiskCache(const TString& filename, ui32 keyTtl, ui32 minTicketTtl);

        TKeyList::TData ExtractKeys() {
            return std::move(InitialValue_.Keys);
        }

        TStorage::TData ExtractTickets() {
            return std::move(InitialValue_.Tickets);
        }

        void WriteCache(const TKeyList::TData& keys, const TStorage::TData& tickets, const time_t now = time(nullptr)) const;

    public:
        static TDiskCache FromMemory(const TString& body, ui32 keyTtl, ui32 minTicketTtl, const time_t now = time(nullptr));
        TString ToArray(const TKeyList::TData& keys, const TStorage::TData& tickets, const time_t now = time(nullptr)) const;

    private:
        void Init(const TString& body, const time_t now = time(nullptr));

    private:
        const TString Filename_;
        const ui32 KeyTtl_;
        const ui32 MinTicketTtl_;

        struct TInitialValue {
            TKeyList::TData Keys;
            TStorage::TData Tickets;
        } InitialValue_;
    };
}
