#pragma once

#include "disk_cache.h"
#include "keys.h"
#include "storage.h"

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>

#include <library/cpp/tvmauth/type.h>

#include <util/generic/string.h>

#include <atomic>
#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm {
    class TRuntimeContext;
}

namespace NPassport::NTvm::NPregen {
    class TGenerator;

    class TFacade {
    public:
        explicit TFacade(const TRuntimeContext& runtime);
        virtual ~TFacade();

        TString GetTicket(NTvmAuth::TTvmId src,
                          NTvmAuth::TTvmId dst) const;

        void AddUnistat(NUnistat::TBuilder& builder) const;

    protected:
        void Run();

    private:
        const TRuntimeContext& Runtime_;
        std::unique_ptr<TGenerator> Generator_;
        TDiskCache DiskCache_;
        mutable TKeyList AllKeys_;
        TStorage CurrentStorage_;
        mutable TStorageForNewbies NewbiesStorage_;
        mutable NUnistat::TSignalDiff<> UnistatHit_ = {"ticket_pregeneration.hit"};
        mutable NUnistat::TSignalDiff<> UnistatCache_ = {"ticket_pregeneration.cache"};
        mutable NUnistat::TSignalDiff<> UnistatAll_ = {"ticket_pregeneration.all"};
        mutable NUnistat::TTimeStat UnistatTime_;
    };
}
