#pragma once

#include "keys.h"
#include "storage.h"

#include <passport/infra/daemons/tvmapi/src/runtime_context/dbfetcher.h>

#include <passport/infra/libs/cpp/unistat/diff.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm::NPregen {
    class TGenerator {
    public:
        struct TSettings {
            ui32 KeyTtl = 0;
            ui32 TicketTtl = 0;
            size_t Threads = 1;
        };

        TGenerator(TSettings settings);

        TStorage::TDataPtr GenAll(const TKeyList::TData& keys,
                                  TRwPrivateKeyPtr pk,
                                  const NTvmAuth::TServiceContext& serviceCtx);
        TString GenOne(const TKey& key,
                       const NTvmAuth::NRw::TRwPrivateKey& pk,
                       const NTvmAuth::TServiceContext& serviceCtx,
                       time_t expireTime);

        void AddUnistat(NUnistat::TBuilder& builder) const;

    private:
        const TSettings Settings_;
        NUnistat::TSignalDiff<> UnistatErrors_ = {"internal_error.ticket_pregeneration"};
    };
}
