#include "keys.h"

#include <passport/infra/daemons/tvmapi/src/proto/pregen_raw_list.pb.h>

#include <util/string/split.h>

namespace NPassport::NTvm::NPregen {
    TKeyList::TKeyList(TData&& data)
        : Data_(std::move(data))
        , DataForPregenerartion_(Data_)
    {
    }

    void TKeyList::TryAdd(const TKey& key) {
        const time_t now = time(nullptr);

        // Keys exists
        {
            std::shared_lock lock(Mutex_);
            auto it = Data_.find(key);
            if (it != Data_.end()) {
                it->second->store(now, std::memory_order_relaxed);
                return;
            }
        }

        // New key
        std::unique_lock lock(Mutex_);
        auto [it, inserted] = Data_.emplace(key, nullptr);
        if (inserted) {
            it->second = std::make_shared<std::atomic<time_t>>(now);
            AddedKeys_.emplace(*it);
        }
    }

    const TKeyList::TData& TKeyList::GetDataForPregeneration() {
        {
            std::unique_lock lock(Mutex_);
            for (const auto& pair : AddedKeys_) {
                DataForPregenerartion_.insert(pair);
            }
            AddedKeys_.clear();
        }

        return DataForPregenerartion_;
    }
}
