#pragma once

#include <library/cpp/tvmauth/type.h>

#include <util/generic/string.h>

#include <memory>
#include <set>
#include <shared_mutex>
#include <unordered_map>

namespace NPassport::NTvm::NPregen {
    class TKey {
    public:
        bool operator==(const TKey& o) const {
            return Src == o.Src && Dst == o.Dst;
        }

        const NTvmAuth::TTvmId Src;
        const NTvmAuth::TTvmId Dst;
    };
}

namespace std {
    template <>
    struct hash<NPassport::NTvm::NPregen::TKey> {
        size_t operator()(const NPassport::NTvm::NPregen::TKey& k) const {
            return hash<NTvmAuth::TTvmId>()(k.Src) +
                   hash<NTvmAuth::TTvmId>()(k.Dst);
        }
    };
}

namespace NPassport::NTvm::NPregen {
    class TKeyList {
    public:
        using TTime = std::shared_ptr<std::atomic<time_t>>;
        using TData = std::unordered_map<TKey, TTime>;

        TKeyList(TData&& data);

        void TryAdd(const TKey& key);
        const TData& GetDataForPregeneration();

        template <typename Func>
        static void ProcessData(const TKeyList::TData& data, ui32 keyTtl, Func func, const time_t now = time(nullptr)) {
            for (const auto& pair : data) {
                const time_t lastTime = pair.second->load(std::memory_order_relaxed);

                if (lastTime + keyTtl <= now) {
                    continue;
                }

                func(pair.first, lastTime);
            }
        }

    private:
        mutable std::shared_mutex Mutex_;
        TData Data_;
        TData AddedKeys_;

        TData DataForPregenerartion_; // touched only in TFacade::refresh()
    };
}
