#pragma once

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <util/generic/string.h>

#include <atomic>
#include <memory>
#include <shared_mutex>
#include <unordered_map>

namespace NTvmAuth {
    class TServiceContext;
}
namespace NTvmAuth::NRw {
    class TRwPrivateKey;
}

namespace NPassport::NTvm::NPregen {
    class TGenerator;
    class TKey;

    class TStorage {
    public:
        using TData = std::unordered_map<TKey, TString>;
        using TDataPtr = std::shared_ptr<TData>;

        explicit TStorage(TDataPtr data = std::make_shared<TData>());

        void SetData(TDataPtr data);
        TString GetTicket(const TKey& k) const;

    private:
        NUtils::TSharedState<TData> Data_;
    };

    class TStorageForNewbies {
    public:
        TStorageForNewbies(TGenerator& generator);

        void Reset();

        struct TTicket {
            TString Body;
            bool IsCache = false;
        };

        TTicket GetTicket(const TKey& k,
                          const NTvmAuth::NRw::TRwPrivateKey& pk,
                          const NTvmAuth::TServiceContext& serviceCtx,
                          time_t expireTime);

    private:
        TStorage::TDataPtr Data_;
        TStorage::TDataPtr PrevData_;
        std::shared_timed_mutex Mutex_;
        TGenerator& Generator_;
    };
}
