#pragma once

#include <passport/infra/daemons/tvmapi/src/runtime_context/dbfetcher.h>

namespace NPassport::NTicketSigner {
    class TServiceSigner;
}

namespace NPassport::NJson {
    class TObject;
}

namespace NPassport::NTvm {
    class TResult;
    class TRuntimeContext;

    class TResponseBuilder {
    public:
        TResponseBuilder(const TRuntimeContext& runtime);

        TResult BuildOkResult(const TStringBuf dst,
                              const TDbFetcher::TResult& client,
                              const TDbFetcher::TResult& srcRes,
                              const TString& remoteAddr);

    protected:
        TString BuildOkJson(const TStringBuf dst,
                            const TDbFetcher::TResult& client,
                            const TDbFetcher::TResult& srcRes,
                            const TString& remoteAddr);

        virtual void WriteTicket(NJson::TObject& obj,
                                 const TDbFetcher::TResult& client,
                                 TClientId dst,
                                 time_t expireTime) = 0;

    protected:
        const TRuntimeContext& Runtime_;
    };

    class TClientBuilder: public TResponseBuilder {
    public:
        TClientBuilder(const TRuntimeContext& runtime);

    private:
        void WriteTicket(NJson::TObject& obj,
                         const TDbFetcher::TResult& client,
                         TClientId dst,
                         time_t expireTime) override;
    };

    class TSshBuilder: public TResponseBuilder {
    public:
        TSshBuilder(const TRuntimeContext& runtime, ui64 uid);

    private:
        void WriteTicket(NJson::TObject& obj,
                         const TDbFetcher::TResult& client,
                         TClientId dst,
                         time_t expireTime) override;

    private:
        ui64 Uid_;
    };

    class TVerifySshBuilder {
    public:
        static TString BuildOk(TStringBuf fingerprint);
    };
}
