#include "keys.h"

#include <passport/infra/daemons/tvmapi/src/output/result.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/dbfetcher.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/runtime_context.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/strings.h>
#include <passport/infra/daemons/tvmapi/src/utils/retry_settings.h>
#include <passport/infra/daemons/tvmapi/src/utils/utils.h>

namespace NPassport::NTvm::NV2 {
    TKeysProcessor::TKeysProcessor(const TRuntimeContext& runtime)
        : Runtime_(runtime)
    {
    }

    TResult TKeysProcessor::Process(const NCommon::TRequest& req) const {
        TUtils::GetRequiredArg(req, TStrings::LIB_VERSION_);

        TResult res(*Runtime_.DbFetcher().PublicTvmKeys(), TResult::EContentType::TextPlain);
        Runtime_.GetRetrySettingsHelper().Process(req, res);

        return res;
    }
}
