#include "private_keys.h"

#include <passport/infra/daemons/tvmapi/src/processors/request_context.h>

#include <passport/infra/daemons/tvmapi/src/output/result.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/dbfetcher.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/runtime_context.h>
#include <passport/infra/daemons/tvmapi/src/runtime_context/strings.h>
#include <passport/infra/daemons/tvmapi/src/utils/utils.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <util/string/cast.h>

namespace NPassport::NTvm::NV2 {
    static TResult GetKey(const TRuntimeContext& runtime, TClientId clientId) {
        TPrivateKeysPtr privateBbKeys = runtime.DbFetcher().PrivateBbKeys();

        if (!privateBbKeys) {
            return TResult("No private keys", TStatus::ERROR_FATAL);
        }

        auto it = privateBbKeys->find(clientId);
        if (it == privateBbKeys->end()) {
            return TResult(NUtils::CreateStr("No private keys for client ", clientId), TStatus::ERROR_CLIENT__INCORRECT);
        }

        return TResult(it->second, TResult::EContentType::TextPlain);
    }

    TPrivKeysProcessor::TPrivKeysProcessor(const TRuntimeContext& runtime)
        : Runtime_(runtime)
    {
    }

    TResult TPrivKeysProcessor::Process(const NCommon::TRequest& req) const {
        TRequestContext ctx(req, Runtime_);
        if (!ctx.CheckServiceTicket()) {
            return ctx.Result();
        }

        return GetKey(Runtime_, ctx.Client().Client().Id());
    }
}
