#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/generic/string.h>
#include <util/system/types.h>

#include <memory>
#include <unordered_map>
#include <vector>

class TKeepAliveHttpClient;

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm {
    class TRuntimeContext;
    class TAbcFetcher {
    public:
        TAbcFetcher(const TRuntimeContext& runtime);
        virtual ~TAbcFetcher();

        void AddUnistat(NUnistat::TBuilder& builder) const;

        bool CheckRole(ui64 uid, ui64 serviceId) const;

    protected:
        void Run();

    private:
        struct TCache {
            using TServices = std::vector<ui64>;
            using TMap = std::unordered_map<ui64, TServices>; // uid -> services
            TMap Users;
        };
        using TCachePtr = std::shared_ptr<TCache>;

    private:
        void ReadCacheFromFile();
        void RefreshViaHttp();

        struct TResp {
            TString Body;
            TDuration Time;
        };
        TResp GetPage(TKeepAliveHttpClient& client, size_t entityId) const;

        struct TParsePageResult {
            size_t RoleCount = 0;
            size_t LastId = 0;
        };
        static TParsePageResult ParsePage(rapidjson::Value& doc, TCache& cache);

    private:
        const TRuntimeContext& Runtime_;
        TString Token_;

        NUtils::TSharedState<TCache> Cache_;

        mutable NUnistat::TSignalDiff<> UnistatQueryErrors_ = {"internal_error.abc.query"};
        mutable NUnistat::TSignalDiff<> UnistatParsingErrors_ = {"internal_error.abc.parsing"};
        mutable NUnistat::TTimeStat UnistatResponseTime_;
    };
}
