#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NTvm {
    class TConfig {
    public:
        TConfig(const NXml::TConfig& c, const TString& path);

        struct TOAuth {
            TString Schema;
            TString Host;
            TString Login;
            TString Pwd;
            TString ClientId;
            TString ClientSecret;
        } const Oauth;

        struct TStaff {
            bool Enabled = false;
            ui32 RefreshPeriod = 3600;
            ui32 Retries = 3;
            TString CachePath;
            size_t Limit = 0UL;
            TString Host;
            ui16 Port = 0;
            TDuration ConnectionTimeout;
            TDuration QueryTimeout;
        } const Staff;

        struct TAbc {
            bool Enabled = true;
            ui32 RefreshPeriod = 3600;
            ui32 Retries = 3;
            TString CachePath;
            size_t Limit = 0UL;
            TString Host;
            ui16 Port = 0;
            TDuration ConnectionTimeout;
            TDuration QueryTimeout;
        } const Abc;

        struct TExperiment {
            bool UsePregeneration = true;
        } const Experiment;

        struct TPassportIds {
            ui32 BbProd = 0;
            ui32 BbProdYateam = 0;
            ui32 BbTest = 0;
            ui32 BbTestYateam = 0;
            ui32 BbStress = 0;
            ui32 BbMimino = 0;
            ui32 BbLoad = 0;
            ui32 Tvm = 0;
        } const PassportIds;

        struct TDbFetcher {
            ui32 Retries = 0;
            size_t Period = 0;
            TString KeyFile;
            size_t PreferedPrivateKeyIdx = 0;
            TString DiskCache;
            size_t MinKeyCount = 12;
        } const DbFetcher;

        struct TPregeneration {
            ui32 Period = 0;
            ui32 KeyTtl = 0;
            ui32 TicketMinTtl = 0;
            TString RawListFile;
            size_t Threads = 0;
        } const Pregen;

        struct TGeneral {
            time_t TsAllowedDiff = 0;
            TString ForceDownFile;
            std::vector<ui32> VerifySshClientIds;
            std::vector<ui32> CheckSecretClientIds;
            ui32 TtlServiceTicket = 0;
            time_t KeysAcceptableAge = 0;
            size_t DstCountLimit = 0;
            size_t DstCountWarningLimit = 0;
        } const Gen;

        struct TRetrySettings {
            ui32 ExponentialBackoffMinSec = 0;
            ui32 ExponentialBackoffMaxSec = 0;
            double ExponentialBackoffFactor = 0;
            double ExponentialBackoffJitter = 0;
            ui32 MaxRandomSleepDefaultMsec = 0;
            ui32 MaxRandomSleepWhenOkMsec = 0;
            ui32 RetriesOnStart = 0;
            ui32 RetriesInBackground = 0;
            ui32 WorkerAwakingPeriodSec = 0;
            ui32 DstsLimit = 0;
            ui32 RolesUpdatePeriodSec = 0;
            ui32 RolesWarnPeriodSec = 0;
        } const RetrySettings;

        struct TTvmCertClientSettings {
            TString Host;
            ui16 Port;
            TDuration Timeout;
            ui64 Workers;
        } const TvmCertClientSettings;

    private:
        static TOAuth ReadOAuth(const NXml::TConfig& c, const TString& path);
        static TStaff ReadStaff(const NXml::TConfig& c, const TString& path);
        static TAbc ReadAbc(const NXml::TConfig& c, const TString& path);
        static TExperiment ReadExperiment(const NXml::TConfig& c, const TString& path);
        static TPassportIds ReadPassportIds(const NXml::TConfig& c, const TString& path);
        static TDbFetcher ReadDbFetcher(const NXml::TConfig& c, const TString& path);
        static TPregeneration ReadPregeneration(const NXml::TConfig& c, const TString& path);
        static TGeneral ReadGeneral(const NXml::TConfig& c, const TString& path);
        static TRetrySettings ReadRetrySettings(const NXml::TConfig& c, const TString& path);
        static TTvmCertClientSettings ReadTvmCertClient(const NXml::TConfig& c, const TString& path);

        static std::vector<ui32> ReadClientIds(const TString& clients);
    };
}
