#pragma once

#include "dbfetcher.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <optional>

namespace NTskvFormat {
    class TLogBuilder;
}

namespace NPassport::NUtils {
    class TFileLogger;
}

namespace NPassport::NTvm {
    class TNotifyLog {
    public:
        struct TBaseEntry {
            TBaseEntry(const TDbFetcher::TResult& src, const TString& ip);

            TClientId Src = 0;
            TString SrcIp;
            TString SrcName;
            std::optional<ui64> SrcAbcId;
        };

        struct TDeletedSrc: public TBaseEntry {
            TDeletedSrc(const TDbFetcher::TResult& src, const TString& ip)
                : TBaseEntry(src, ip)
            {
            }
        };

        struct TDeletedDst: public TBaseEntry {
            TDeletedDst(const TDbFetcher::TResult& src, const TString& ip, const TDbFetcher::TResult& dst);

            TClientId Dst = 0;
            TString DstName;
            std::optional<ui64> DstAbcId;
        };

        struct TOldSecret: public TBaseEntry {
            TOldSecret(const TDbFetcher::TResult& src, const TString& ip)
                : TBaseEntry(src, ip)
            {
            }
        };

        TNotifyLog(const TString& filename);
        ~TNotifyLog();

        void Log(const TDeletedSrc& entry, TInstant now = TInstant::Now()) const;
        void Log(const TDeletedDst& entry, TInstant now = TInstant::Now()) const;
        void Log(const TOldSecret& entry, TInstant now = TInstant::Now()) const;

        static TString BuildRow(const TDeletedSrc& entry, TInstant now);
        static TString BuildRow(const TDeletedDst& entry, TInstant now);
        static TString BuildRow(const TOldSecret& entry, TInstant now);

        static void AddBase(NTskvFormat::TLogBuilder& builder, const TBaseEntry& entry);

    private:
        static NTskvFormat::TLogBuilder CreateBuilder(TInstant now);

    private:
        std::unique_ptr<NUtils::TFileLogger> Logger_;
    };

    using TTNotifyLogPtr = std::unique_ptr<TNotifyLog>;
}
